<?php
extract ( shortcode_atts ( array (
	'image' => '',
	'title' => '',
	'alt' => '',
	'align' => 'center',
	'action' => '',
	'image_link' => '',
	'open_new' => '',
	'lightbox_image' => '',
	'lightbox_video' => '',
	'lightbox_id' => '',
	'magnify_image' => '',
	'hover_action' => '',
	'hover_image' => '',
	'hover_transition' => '',
	'image_text' => '',
	'image_link_caption' => '',
	'style' => '',
	'border_color' => 'sm-grey-light',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '',
	'css' => '',
), $atts ) );

$css_class = array( 'sm-image' );
$align = sm_validate_with_array( $align, sm_get_image_aligns_array() );

if ( 'inline' != $align ) {
	$css_class = array_merge( $css_class, array( 'sm_content_element', 'clearfix' ) );
}

$css_class[] = $align;

$action = sm_validate_with_array( $action, sm_get_image_actions_array() );
$hover_action = sm_validate_with_array( $hover_action, sm_get_image_hover_actions_array() );

if ( empty( $title ) ) {  // if not set, use attachment post title
	$title = get_the_title( $image );
}
if ( empty( $alt ) ) { // if not set, use pre-set attachment alt
	$alt = get_post_meta( $image, '_wp_attachment_image_alt', true );
	if ( empty( $alt ) ) $alt = $title;
}

if ( !empty( $css ) ) {
	$css_class[] = sm_shortcode_custom_css_class( $css );
}

$css_class = implode( ' ', $css_class );
$css_class .= sm_get_css_animation( $css_animation );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
if ( intval( $animation_delay ) > 0 ) {
	$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
}

$image_url = wp_get_attachment_url( $image );

if( $lightbox_id != '' ) {
	$rel = "prettyPhoto[{$lightbox_id}]";
} else {
	$rel = "prettyPhoto";
}

$hover_image_url = $image_url;
if ( !empty( $hover_image ) ) {
	$hover_image_url = wp_get_attachment_url( $hover_image );
}

$magnify_image_url = $image_url;
if ( !empty( $magnify_image ) ) {
	$magnify_image_url = wp_get_attachment_url( $magnify_image );
}

$a_attributes = array();
if ( 'sm-action-link' == $action || 'sm-action-text' == $action ) {
	if ( empty( $image_link ) ) $image_link = '#'; // Fall back to #
	$a_attributes[] = 'href="' . esc_url( $image_link ) . '"';
	$a_attributes[] = 'title="' . esc_attr( $title ) . '"';
	if ( 'true' == $open_new ) $a_attributes[] = 'target="_blank"';
} else if( 'sm-action-image' == $action ) {
	$lightbox_image_url = $image_url;
	if ( !empty( $lightbox_image ) ) {
		$lightbox_image_url = wp_get_attachment_url( $lightbox_image );
	}
	$a_attributes[] = 'href="' . esc_url( $lightbox_image_url ) . '"';
	$a_attributes[] = 'class="sm-prettyphoto"';
	$a_attributes[] = 'data-rel="' . esc_attr( $rel ) . '"';
} else if ( 'sm-action-video' == $action ) {
	$a_attributes[] = 'href="' . esc_url( $lightbox_video ) . '"';
	$a_attributes[] = 'data-rel="' . esc_attr( $rel ) . '"';
}

$style = sm_validate_with_array( $style, sm_get_image_styles_array() );
$border_color = sm_validate_with_array( $border_color, sm_get_image_border_colors_array() );
$wrap_class = array( 'sm-image-wrap' );
if ( !empty( $style ) ) {
	$wrap_class[] = $style;
	$wrap_class[] = $border_color;
}
if ( 'sm-hover-lighten' == $hover_action || 'sm-hover-darken' == $hover_action ) {
	$wrap_class[] = $hover_action;
}

$wrap_class = implode( ' ', $wrap_class );
?>
<?php if ( 'sm-action-magnify' == $action ) : ?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
		<div class="sm-magnify-wrapper">
			<img class="magnify-image" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $alt ); ?>" data-big="<?php echo esc_url( $magnify_image_url ); ?>" />
		</div>
	</div>
<?php elseif ( 'sm-action-text' == $action ) : ?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
		<div class="sm-image-wrap">
			<div class="sm-action-text">
				<img src="<?php echo esc_url( $image_url ); ?>" class="single-image" alt="<?php echo esc_attr( $alt ); ?>" />
				<div class="sm-overlay-text-wrap">
					<?php echo wpautop( $image_text ); ?>
					<?php if ( !empty( $image_link ) ) : ?>
						<div class="text-link"><a <?php echo implode( ' ', $a_attributes ); ?>><?php echo esc_html( $image_link_caption ); ?></a></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
<?php else: ?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php if( !empty( $a_attributes ) ) : ?>
		<a <?php echo implode( ' ', $a_attributes ); ?>>
	<?php endif; ?>
			<div class="<?php echo esc_attr( $wrap_class ); ?>">
			<?php if ( 'sm-hover-overlay' == $hover_action ) : ?>
				<div class="sm-image-wrap-overlay">
					<div class="pp-image-hover"><i class="fa fa-search-plus"></i></div>
			<?php elseif ( 'sm-hover-image' == $hover_action ) : ?>
				<div class="sm-image-wrap-hover-img<?php if ( 'true' == $hover_transition ) : ?> hover-trans<?php endif; ?>">
			<?php endif; ?>
				<?php if ( !empty( $image_url ) ): ?>
					<img src="<?php echo esc_url( $image_url ); ?>" class="single-image" alt="<?php echo esc_attr( $alt ); ?>" />
				<?php endif; ?>
			<?php if ( 'sm-hover-lighten' == $hover_action || 'sm-hover-darken' == $hover_action ) : ?>
				<div class="lida-image-hover"></div>
			<?php elseif ( 'sm-hover-overlay' == $hover_action ) : ?>
				</div>
			<?php elseif ( 'sm-hover-image' == $hover_action ) : ?>
					<img src="<?php echo esc_url( $hover_image_url ); ?>" class="hover-image" alt="<?php echo esc_attr( $alt ); ?>" />
				</div>
			<?php endif; ?>
			</div>
	<?php if( !empty( $a_attributes ) ) : ?>
		</a>
	<?php endif; ?>
	</div>
<?php endif; ?>